<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */


$optional_vars = array( 'current_user' => '',
						'display_name' => '',
						'json_mailbox_list' => '{}', 
						'mailboxes' => '',
						'other_members' => array(),
						'title' => '',
						'show_workflow' => false);

//make sure that optional vars all have a value
foreach( $optional_vars as $optional_var => $default_value){
	if(!isset($$optional_var)) $$optional_var = $default_value;
}

//set up the mailbox list
$mailbox_list = array();
$json_decoded_mailbox_list = json_decode($json_mailbox_list);
if(is_array($json_decoded_mailbox_list)){
	foreach($json_decoded_mailbox_list as $mailbox) $mailbox_list[$mailbox->link] = $mailbox->label;
}
//set up other members (TODO - can we just take care of this in the controller?)
foreach($other_members as $key => $member){
	$other_members[$member['id']] = $member['name'];
	unset($other_members[$key]);
}

$user_feedback_message = $this->session->userdata('message');

if(!empty($_SESSION['unseen']))
	$title .= ' ('.$_SESSION['unseen'].')';

echo $this->load->view('header/header', compact('title'), TRUE );
echo $this->load->view('message_modal', array('message' => $user_feedback_message), TRUE);
echo $this->load->view('disabled_service_notification', array(), TRUE);
?>

<input style="display:none;" id="current_user" value="<?PHP echo $current_user ?>"/>
<input style="display:none;" id="display_name" value="<?PHP echo $display_name ?>"/>
<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a> <a class="hidden_context hidden_link" name="menuContent" id="skipMenu" href="#mailboxListContent">Skip Menu</a>
<div id="menu">
	<div id="menuwrap">
		<div id="buttons">
			<button class="minimal minimal-short" type="button" id="get_mail_btn" onclick="ajaxMessageCheck(this);">Get Mail</button>
			<?PHP if ($folder_name!="Archived") {
				echo '<button type="submit" class="minimal minimal-short" id="archive_btn" name="archive" disabled="disabled" aria-hidden="true" style="width: 135px;">Archive Message</button>';
				echo '<input type="submit" class="hidden_context" name="archive_hidden" id="archive_hidden" value="Archive" />';
			} ?>
			<?PHP echo form_hidden('last_button', $this->session->flashdata('last_button'), 'last_button'); ?>
			<?PHP if ($folder_name!="Draft" && $folder_name!="Sent") {
				echo '<label for="move_select" class="hidden_context">Select Mailbox for Move</label>';
				echo form_dropdown('move_select', $mailbox_list, '', 'id="move_select" class="hidden_context"');
				echo '<input type="submit" name="move_hidden" id="move_hidden" class="hidden_context" value="Move" />';
				echo '<button type="button" class="minimal minimal-short" id="move_btn" name="move" disabled="disabled" aria-hidden="true">Move</button>';
			} ?>
			<?PHP if($show_workflow): ?>
			<button type="button" class="minimal minimal-short" id="assign_button" name="assign_button" disabled="disabled" aria-hidden="true">Assign &#x25BE;</button>
			<label for="assign_select" class="hidden_context">Select Group Member for Assign</label>
			<?php echo form_dropdown('assign_select', $other_members,'', 'id="assign_select" class="hidden_context"'); ?>
			<input type="button" name="assign_select_btn_hidden" id="assign_select_btn_hidden" class="hidden_context" onclick="assign_selected($('#assign_select option:selected').val(),$('#assign_select option:selected').text());" value="Assign Select"/>
			<button type="button" onclick="complete_selected();" class="minimal minimal-short" id="complete_button"  name="complete_button" disabled="disabled" aria-hidden="true">Complete</button>
			<button type="button" onclick="complete_selected();" class="hidden_context" id="complete_button_hidden"  name="complete_button_hidden" aria-hidden="true">Complete</button>
			<?php endif ?>
			<input type="submit"  style="display:none;" id="mark_as_read_btn" name="mark_as_read" aria-hidden="true" />
			<input type="submit"  style="display:none;" id="mark_as_read_unbtn" name="mark_as_unread" aria-hidden="true" />
			<input type="submit" class="hidden_context" name="mark_as_read_hidden" id="mark_as_read_hidden" value="Mark as Read" />
			<input type="submit" class="hidden_context" name="mark_as_unread_hidden" id="mark_as_unread_hidden" value="Mark as Unread" />
			<button type="button" data-dropdown="#dropdown-1" class="minimal minimal-short" title="More menu" id="more_button"  name="more_button" disabled="disabled" aria-hidden="true">More &#x25BE;</button>
			<div id="dropdown-1" class="dropdown dropdown-tip dropdown-relative dropdown-anchor-right">
				<ul class="dropdown-menu">
					<li><a onclick="$('#mark_as_read_btn').trigger('click');" href="#">Mark as read</a></li>
					<li><a onclick="$('#mark_as_read_unbtn').trigger('click');" href="#">Mark as unread</a></li>
				</ul>
			</div>
		</div>
	<?php if(!empty($message_count)): ?>		
		<div id="pagination">
			<span class="text"><?php echo $page_start ?><abbr title="to">-</abbr><?php echo $message_count + $page_start - 1?> of <?php echo $total ?></span>
			<?php if($page_start > 1): //if this is not the first page ?>
			<a class="move_page" href="<?php echo site_url('inbox/page/'.($page_start - INBOX_DISPLAY_PER_PAGE)) ?>"><span><img src="/images/lt.png" alt="Previous Page" height="10" /></span></a>
			<?php endif ?>
			<?php if($page_start + INBOX_DISPLAY_PER_PAGE <= $total && $message_count <= INBOX_DISPLAY_PER_PAGE): //if this is not the last page, display a next page link ?>
			<a class="move_page" href="<?php echo site_url('inbox/page/' . ($page_start + INBOX_DISPLAY_PER_PAGE)) ?>"><span><img src="/images/gt.png" alt="Next Page" height="10" /></span></a>
			<?php endif ?>		
		</div>
	<?php endif ?>	
	</div>
</div>
</div>
<div id="header_padding"></div>
<?php if(!empty($user_feedback_message)) echo $user_feedback_message; ?>
<div id="mailbox_wrapper"> <a name="mailboxListContent" id="mailboxListContent" class="hidden_context hidden_link">Mailbox List</a> <a class="hidden_context hidden_link" href="#mainContent" id="skipMailboxList">Skip Mailbox List</a>
	<div id="mailboxes">
		<button class="minimal" type="button" id="compose_btn" name="compose" onclick="document.location.href='<?PHP echo site_url('inbox/compose'); ?>';">Compose</button>
		<br />
		<br />
		<h2 class="hidden_context">Mailbox Folder Menu</h2>
		<?PHP echo $mailboxes; ?> 
	</div>
	<a class="hidden_context hidden_link" href="#menuContent" id="skipToMenu">Skip to Menu</a> 
</div>
<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
<h2 class="hidden_context">Message List</h2>
<div id="msg_pane"> 
	<?php if(!empty($search_message)): ?><h3><?php echo $search_message ?></h3><?php endif ?>
	<?php echo $contents ?> 
</div>
<?PHP echo form_close(); ?>
</div>
<?PHP $this->load->view('footer'); ?>
</body>
<script type="text/javascript">
	$(document).ready(function(){
		var lastLeft = -1,
		menu = $('#mailbox_wrapper, #header');

		$('#mailbox_wrapper').css('position', 'absolute');
		$(window).on('scroll resize', function(){
			var totalWidth = $('#wrapper').css('width').slice(0,-2);
			if (totalWidth > window.innerWidth) {
				$('#header').css('margin-left', '3%');
				var left = $(window).scrollLeft();
				if (left >= 0 && left!==lastLeft){
					lastLeft = left;
					menu.css('left',-left+'px');
				}
			}
		});
	});
</script>
</html>